% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigleaf_constants.r
\name{bigleaf.constants}
\alias{bigleaf.constants}
\title{Constants Used in the bigleaf Package}
\usage{
bigleaf.constants(
  cp = 1004.834,
  Rgas = 8.31451,
  Rv = 461.5,
  Rd = 287.0586,
  Md = 0.0289645,
  Mw = 0.0180153,
  eps = 0.622,
  g = 9.81,
  solar_constant = 1366.1,
  pressure0 = 101325,
  Tair0 = 273.15,
  k = 0.41,
  Cmol = 0.012011,
  Omol = 0.0159994,
  H2Omol = 0.01801528,
  sigma = 5.670367e-08,
  Pr = 0.71,
  Sc_CO2 = 1.07,
  Le067 = 0.93,
  Kelvin = 273.15,
  DwDc = 1.6,
  days2seconds = 86400,
  kPa2Pa = 1000,
  Pa2kPa = 0.001,
  umol2mol = 1e-06,
  mol2umol = 1e+06,
  kg2g = 1000,
  g2kg = 0.001,
  kJ2J = 1000,
  J2kJ = 0.001,
  se_median = 1.253,
  frac2percent = 100
)
}
\arguments{
\item{cp}{Specific heat of air for constant pressure (J K-1 kg-1)}

\item{Rgas}{Universal gas constant (J mol-1 K-1)}

\item{Rv}{Gas constant of water vapor (J kg-1 K-1) (Stull 1988 p.641)}

\item{Rd}{Gas constant of dry air (J kg-1 K-1) (Foken p. 245)}

\item{Md}{Molar mass of dry air (kg mol-1)}

\item{Mw}{Molar mass of water vapor (kg mol-1)}

\item{eps}{Ratio of the molecular weight of water vapor to dry air (=Mw/Md)}

\item{g}{Gravitational acceleration (m s-2)}

\item{solar_constant}{Solar constant (W m-2)}

\item{pressure0}{Reference atmospheric pressure at sea level (Pa)}

\item{Tair0}{Reference air temperature (K)}

\item{k}{von Karman constant}

\item{Cmol}{Molar mass of carbon (kg mol-1)}

\item{Omol}{Molar mass of oxygen (kg mol-1)}

\item{H2Omol}{Molar mass of water (kg mol-1)}

\item{sigma}{Stefan-Boltzmann constant (W m-2 K-4)}

\item{Pr}{Prandtl number}

\item{Sc_CO2}{Schmidt number for CO2}

\item{Le067}{Lewis number for water vapor to the power of 0.67}

\item{Kelvin}{Conversion degree Celsius to Kelvin}

\item{DwDc}{Ratio of the molecular diffusivities for water vapor and CO2}

\item{days2seconds}{Seconds per day}

\item{kPa2Pa}{Conversion kilopascal (kPa) to pascal (Pa)}

\item{Pa2kPa}{Conversion pascal (Pa) to kilopascal (kPa)}

\item{umol2mol}{Conversion micromole (umol) to mole (mol)}

\item{mol2umol}{Conversion mole (mol) to micromole (umol)}

\item{kg2g}{Conversion kilogram (kg) to gram (g)}

\item{g2kg}{Conversion gram (g) to kilogram (kg)}

\item{kJ2J}{Conversion kilojoule (kJ) to joule (J)}

\item{J2kJ}{Conversion joule (J) to kilojoule (kJ)}

\item{se_median}{Conversion standard error (SE) of the mean to SE of the median}

\item{frac2percent}{Conversion between fraction and percent}
}
\description{
This function defines the following constants:
}
\details{
This function is passed as an argument to every function that uses one
         or more constants. Individual constants passed to a function can be
         easily altered. E.g. the following command will change the value of
         the von Karman constant from 0.41 to 0.4:

         \code{bigleaf.constants(k=0.4)}

         the value of a constant can be returned by calling:

         \code{bigleaf.constants()$*name_of_constant*}

         To permanently change the constants contained within this function (which
         makes sense for some of them, e.g. for the von Karman constant),
         the command \code{\link[utils]{fixInNamespace}} can be used. E.g.

         \code{fixInNamespace(bigleaf.constants,ns="bigleaf")}

         Note that this has to be repeated every time the package is newly installed/loaded.
}
