% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{virtual.temp}
\alias{virtual.temp}
\title{Virtual Temperature}
\usage{
virtual.temp(
  Tair,
  pressure,
  VPD,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants()
)
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat. 
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{Kelvin - conversion degree Celsius to Kelvin \cr
eps - ratio of the molecular weight of water vapor to dry air (-)}
}
\value{
\item{Tv -}{virtual temperature (deg C)}
}
\description{
Virtual temperature, defined as the temperature at which dry air would have the same
             density as moist air at its actual temperature.
}
\details{
the virtual temperature is given by:
 
   \deqn{Tv = Tair / (1 - (1 - eps) e/pressure)}

 where Tair is in Kelvin (converted internally). Likewise, VPD is converted 
 to actual vapor pressure (e in kPa) with \code{\link{VPD.to.e}} internally.
}
\examples{
virtual.temp(25,100,1.5)                        
              
}
\references{
Monteith J.L., Unsworth M.H., 2008: Principles of Environmental Physics.
            3rd edition. Academic Press, London.
}
