% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{fread2}
\alias{fread2}
\title{Read a text file}
\usage{
fread2(file, ..., data.table = FALSE,
  nThread = getOption("bigreadr.nThread"))
}
\arguments{
\item{file}{Path to the file that you want to read from.}

\item{...}{Other arguments to be passed to \link[data.table:fread]{data.table::fread}.}

\item{data.table}{Whether to return a \code{data.table} or just a \code{data.frame}?
Default is \code{FALSE} (and is the opposite of \link[data.table:fread]{data.table::fread}).}

\item{nThread}{Number of threads to use. Default uses all threads minus one.}
}
\value{
A \code{data.frame} by default; a \code{data.table} when \code{data.table = TRUE}.
}
\description{
Read a text file
}
\examples{
tmp <- fwrite2(iris)
iris2 <- fread2(tmp)
all.equal(iris2, iris)  ## fread doesn't use factors
}
