% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq-download.R
\name{bq_table_download}
\alias{bq_table_download}
\title{Download table data}
\usage{
bq_table_download(
  x,
  n_max = Inf,
  page_size = NULL,
  start_index = 0L,
  max_connections = 6L,
  quiet = NA,
  bigint = c("integer", "integer64", "numeric", "character"),
  api = c("json", "arrow"),
  billing = x$project
)
}
\arguments{
\item{x}{A \link{bq_table}}

\item{n_max}{Maximum number of results to retrieve. Use \code{Inf} to retrieve all
rows.}

\item{page_size}{(JSON only) The number of rows requested per chunk. It is
recommended to leave this unspecified until you have evidence that the
\code{page_size} selected automatically by \code{bq_table_download()} is problematic.

When \code{page_size = NULL} bigrquery determines a conservative, natural chunk
size empirically. If you specify the \code{page_size}, it is important that each
chunk fits on one page, i.e. that the requested row limit is low enough to
prevent the API from paginating based on response size.}

\item{start_index}{(JSON only) Starting row index (zero-based).}

\item{max_connections}{(JSON only) Number of maximum simultaneous
connections to BigQuery servers.}

\item{quiet}{If \code{FALSE}, displays progress bar; if \code{TRUE} is silent;
if \code{NA} picks based on whether or not you're in an interactive context.}

\item{bigint}{The R type that BigQuery's 64-bit integer types should be
mapped to. The default is \code{"integer"}, which returns R's \code{integer} type,
but results in \code{NA} for values above/below +/- 2147483647. \code{"integer64"}
returns a \link[bit64:bit64-package]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{api}{Which API to use? The \code{"json"} API works where ever bigrquery
does, but is slow and can require fiddling with the \code{page_size} parameter.
The \code{"arrow"} API is faster and more reliable, but only works if you
have also installed the bigrquerystorage package.

Because the \code{"arrow"} API is so much faster, it will be used automatically
if the bigrquerystorage package is installed.}

\item{billing}{(Arrow only) Project to bill; defaults to the project of \code{x},
and typically only needs to be specified if you're working with public
datasets.}
}
\value{
Because data retrieval may generate list-columns and the \code{data.frame}
print method can have problems with list-columns, this method returns
a tibble. If you need a \code{data.frame}, coerce the results with
\code{\link[=as.data.frame]{as.data.frame()}}.
}
\description{
This function provides two ways to download data from BigQuery, transfering
data using either JSON or arrow, depending on the \code{api} argument. If
bigrquerystorage is installed, \code{api = "arrow"} will be used (because it's
so much faster, but see the limitions below), otherwise you can select
deliberately by using \code{api = "json"} or \code{api = "arrow"}.
\subsection{Arrow API}{

The arrow API is much faster, but has heavier dependencies: bigrquerystorage
requires the arrow package, which can be tricky to compile on Linux (but you
usually should be able to get a binary from
\href{https://p3m.dev/}{Posit Public Package Manager}.

There's one known limitation of \code{api = "arrow"}: when querying public data,
you'll now need to provide a \code{billing} project.
}

\subsection{JSON API}{

The JSON API retrieves rows in chunks of \code{page_size}. It is most suitable
for results of smaller queries (<100 MB, say). Unfortunately due to
limitations in the BigQuery API, you may need to vary this parameter
depending on the complexity of the underlying data.

The JSON API will convert nested and repeated columns in to list-columns
as follows:
\itemize{
\item Repeated values (arrays) will become a list-column of vectors.
\item Records will become list-columns of named lists.
\item Repeated records will become list-columns of data frames.
}
}
}
\section{Google BigQuery API documentation}{

\itemize{
\item \href{https://cloud.google.com/bigquery/docs/reference/rest/v2/tabledata/list}{list}
}
}

\examples{
\dontshow{if (bq_testable()) withAutoprint(\{ # examplesIf}
df <- bq_table_download("publicdata.samples.natality", n_max = 35000, billing = bq_test_project())
\dontshow{\}) # examplesIf}
}
