% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed-class.R
\docType{class}
\name{bed-class}
\alias{bed-class}
\alias{bed_RC}
\alias{bed}
\title{Class bed}
\usage{
bed(bedfile)
}
\arguments{
\item{bedfile}{Path to file with extension ".bed" to read.
You need the corresponding ".bim" and ".fam" in the same directory.}
}
\description{
A reference class for storing a pointer to a mapped version of a bed file.
}
\details{
A \code{bed} object has many field:
\itemize{
\item \verb{$address}: address of the external pointer containing the underlying
C++ object, to be used internally as a \verb{XPtr<bed>} in C++ code
\item \verb{$extptr}: use \verb{$address} instead
\item \verb{$bedfile}: path to the bed file
\item \verb{$bimfile}: path to the corresponding bim file
\item \verb{$famfile}: path to the corresponding fam file
\item \verb{$prefix}: path without extension
\item \verb{$nrow}: number of samples in the bed file
\item \verb{$ncol}: number of variants in the bed file
\item \verb{$map}: data frame read from \verb{$bimfile}
\item \verb{$fam}: data frame read from \verb{$famfile}
\item \verb{$.map}: use \verb{$map} instead
\item \verb{$.fam}: use \verb{$fam} instead
\item \verb{$light}: get a lighter version of this object for parallel algorithms
to not have to transfer e.g. \verb{$.map}.
}
}

\examples{
bedfile <- system.file("extdata", "example-missing.bed", package = "bigsnpr")
(obj.bed <- bed(bedfile))

}
