% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify-positions.R
\name{snp_modifyBuild}
\alias{snp_modifyBuild}
\title{Modify genome build}
\usage{
snp_modifyBuild(
  info_snp,
  liftOver,
  from = "hg18",
  to = "hg19",
  check_reverse = TRUE,
  local_chain = NULL,
  base_url = "https://hgdownload.soe.ucsc.edu/goldenPath/"
)
}
\arguments{
\item{info_snp}{A data frame with columns "chr" and "pos".}

\item{liftOver}{Path to liftOver executable. Binaries can be downloaded at
\url{https://hgdownload.cse.ucsc.edu/admin/exe/macOSX.x86_64/liftOver} for Mac
and at \url{https://hgdownload.cse.ucsc.edu/admin/exe/linux.x86_64/liftOver}
for Linux.}

\item{from}{Genome build to convert from. Default is \code{hg18}.}

\item{to}{Genome build to convert to. Default is \code{hg19}.}

\item{check_reverse}{Whether to discard positions for which we cannot go back
to initial values by doing 'from -> to -> from'. Default is \code{TRUE}.}

\item{local_chain}{Local chain file (e.g. \code{hg18ToHg19.over.chain.gz}) to use
instead of downloading one from parameters \code{from} and \code{to} (the default).
You can download one such file from e.g.
\url{https://hgdownload.soe.ucsc.edu/goldenPath/hg18/liftOver/}.
Provide a vector of two when using \code{check_reverse}.}

\item{base_url}{From where to download the chain files. Default is
\code{"https://hgdownload.soe.ucsc.edu/goldenPath/"}. You can also try
replacing \code{https} by \code{http}, and/or \code{soe} by \code{cse}.}
}
\value{
Input data frame \code{info_snp} with column "pos" in the new build.
}
\description{
Modify the physical position information of a data frame
when converting genome build using executable \emph{liftOver}.
}
\references{
Hinrichs, Angela S., et al. "The UCSC genome browser database: update 2006."
Nucleic acids research 34.suppl_1 (2006): D590-D598.
}
