% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{snp_fastImputeSimple}
\alias{snp_fastImputeSimple}
\title{Fast imputation}
\usage{
snp_fastImputeSimple(
  Gna,
  method = c("mode", "mean0", "mean2", "random", "zero"),
  ncores = 1
)
}
\arguments{
\item{Gna}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
You can have missing values in these data.}

\item{method}{Either \code{"random"} (sampling according to allele frequencies),
\code{"mean0"} (rounded mean), \code{"mean2"} (rounded mean to 2 decimal places),
\code{"mode"} (most frequent call), \code{"zero"} (by 0).}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
A new \code{FBM.code256} object (same file, but different code).
}
\description{
Fast imputation via mode, mean, sampling according to allele frequencies, or 0.
}
\examples{
bigsnp <- snp_attachExtdata("example-missing.bed")
G <- bigsnp$genotypes
G[, 2]  # some missing values
G2 <- snp_fastImputeSimple(G)
G2[, 2]  # no missing values anymore
G[, 2]  # imputed, but still returning missing values
G$copy(code = CODE_IMPUTE_PRED)[, 2]  # need to decode imputed values

}
\seealso{
\code{\link[=snp_fastImpute]{snp_fastImpute()}}
}
