% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.R
\name{snp_cor}
\alias{snp_cor}
\title{Correlation matrix}
\usage{
snp_cor(
  Gna,
  ind.row = rows_along(Gna),
  ind.col = cols_along(Gna),
  size = 500,
  alpha = 1,
  fill.diag = TRUE,
  infos.pos = NULL,
  ncores = 1
)
}
\arguments{
\item{Gna}{A \link[=FBM.code256-class]{FBM.code256}
(typically \verb{<bigSNP>$genotypes}).\cr
You can have missing values in these data.}

\item{ind.row}{An optional vector of the row indices (individuals) that
are used. If not specified, all rows are used.\cr
\strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices (SNPs) that are used.
If not specified, all columns are used.\cr
\strong{Don't use negative indices.}}

\item{size}{For one SNP, window size around this SNP to compute correlations.
Default is \code{500}. If not providing \code{infos.pos} (\code{NULL}, the default), this is
a window in number of SNPs, otherwise it is a window in kb (genetic distance).}

\item{alpha}{Type-I error for testing correlations.
Default is \code{1} (no threshold is applied).}

\item{fill.diag}{Whether to fill the diagonal with 1s (the default)
or to keep it as 0s.}

\item{infos.pos}{Vector of integers specifying the physical position
on a chromosome (in base pairs) of each SNP.\cr
Typically \verb{<bigSNP>$map$physical.pos}.}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}
}
\value{
The (Pearson) correlation matrix. This is a sparse symmetric matrix.
}
\description{
Get significant (Pearson) correlations between nearby SNPs of the same chromosome
(p-values are computed using a two-sided t-test).
}
\examples{
test <- snp_attachExtdata()

corr <- snp_cor(test$genotypes, ind.col = 1:1000)
corr[1:10, 1:10]

# Sparsity
length(corr@x) / length(corr)

}
