% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts.R
\name{big_counts}
\alias{big_counts}
\title{Counts}
\usage{
big_counts(X.code, ind.row = rows_along(X.code),
  ind.col = cols_along(X.code), byrow = FALSE)
}
\arguments{
\item{X.code}{A \link[=FBM.code256-class]{FBM.code256}.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{byrow}{Count by rows rather than columns?
Default is \code{FALSE} (columns).}
}
\value{
A matrix of counts of K x m (or n) elements, where
\itemize{
\item K is the number of unique elements of the \code{BM.code},
\item n is its number of rows,
\item m is its number of columns.
}

\strong{Beware that K is up to 256. So, if you apply this on a Filebacked Big
Matrix of one million columns, you will create a matrix of nearly 1GB!}.
}
\description{
Counts by columns (or rows) the number of each unique element of a
\code{FBM.code256}.
}
\examples{
X <- big_attachExtdata()
class(X)
X[1:5, 1:10]

# Without the "decoding"
X2 <- big_copy(X)
class(X2)
X2[1:5, 1:10]

# Change the code
code <- rep(NA_real_, 256)
code[1:3] <- c(2, 5, 9)
X$code256 <- code
X[1:5, 1:10]

# by columns
big_counts(X, ind.col = 1:10)

apply(X[, 1:10], 2, table, exclude = NULL)

# by rows
big_counts(X, ind.row = 1:10, byrow = TRUE)
apply(X[1:10, ], 1, table, exclude = NULL)
}
