% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_simulate_list.R
\name{simulate_list}
\alias{simulate_list}
\title{simulate_l}
\usage{
simulate_list(
  data,
  id = 1,
  obj_func,
  n_params,
  n_trials,
  lower,
  upper,
  iteration = 10,
  seed = 123
)
}
\arguments{
\item{data}{[data.frame] raw data. 
This data should include the following mandatory columns: 
- "sub", "time_line", "L_choice", "R_choice", "L_reward", "R_reward".}

\item{id}{[vector] which subject is going to be analyzed.
is being analyzed. The value should correspond to an entry in the "sub" 
column, which must contain the subject IDs. 
e.g., `id = c(1:40)`}

\item{obj_func}{[function] a function with only ONE argument `params`. 
Additionally, it is important to note that the data needs to be retrieved 
from parent.frame(). This function returns the binaryRL.res(res).}

\item{n_params}{[integer] The number of free parameters in your model.}

\item{n_trials}{[integer] The total number of trials in your experiment.}

\item{lower}{[vector] lower bounds of free parameters}

\item{upper}{[vector] upper bounds of free parameters}

\item{iteration}{[integer] the number of iteration}

\item{seed}{[integer] random seed. This ensures that the results are 
reproducible and remain the same each time the function is run. 
default: `seed = 123`}
}
\value{
a list with fake data generated by random free parameters
}
\description{
This function generates simulated data using a
user-defined objective function. You can specify the number of
iterations to control how many data are generated.
These datasets can be used for parameter recovery and model recovery. 
For more information, please refer to the GitHub repository:
https://github.com/yuki-961004/binaryRL
}
