% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isothermal_criterions.R
\name{criterium_A_iso}
\alias{criterium_A_iso}
\title{Objective function for A-optimal OED with detection limit}
\usage{
criterium_A_iso(x, model, pars, limit)
}
\arguments{
\item{x}{a numeric vector of length \code{n} defining the design matrix.
The first n/2 elements are the time points and the last n/2 are the 
temperatures of these points.}

\item{model}{character string defining the inactivation model to use.}

\item{pars}{list defining the model parameters according to the rules defined in the bioinactivation package.}

\item{limit}{numerical value describing the maximum number of log-reductions
that can be identified in the experiment limit = logDL - logN0, where DL
is the detection limit.}
}
\value{
Numeric value of the objective function for criterium A, which is a determinant of the FIM.
}
\description{
Points outside of the allowable area are moved back in time to the 
detection limit
}
