% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcs.R
\name{rcs}
\alias{rcs}
\alias{rcs.vp}
\alias{rcs.list}
\alias{rcs.vpts}
\alias{rcs.vpi}
\title{Get radar cross section}
\usage{
rcs(x)

\method{rcs}{vp}(x)

\method{rcs}{list}(x)

\method{rcs}{vpts}(x)

\method{rcs}{vpi}(x)
}
\arguments{
\item{x}{A \code{vp}, list of \code{vp} or \code{vpts} object.}
}
\value{
a radar cross section in cm^2
}
\description{
Gives the currently assumed radar cross section in cm^2.
}
\details{
See also \link{rcs<-} for changing or setting the radar cross section
of an object.
}
\section{Methods (by class)}{
\itemize{
\item \code{vp}: radar cross section of a vertical profile

\item \code{list}: radar cross sections for a list of vertical profiles

\item \code{vpts}: radar cross section of a time series of vertical profile

\item \code{vpi}: radar cross section of a time series of vertically
integrated vertical profile(s)
}}

\examples{
# load example data:
data(example_vp)
data(example_vpts)

# retrieve RCS for a single vertical profile:
rcs(example_vp)

# retrieve RCS for a vertical profile time series:
rcs(example_vpts)

# change or set RCS for a single vertical profile:
rcs(example_vp) <- 11

# change or set RCS for a vertical profile time series:
rcs(example_vpts) <- 11
}
