% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcs.R
\name{rcs}
\alias{rcs}
\alias{rcs.vp}
\alias{rcs.list}
\alias{rcs.vpts}
\alias{rcs.vpi}
\title{Get radar cross section}
\usage{
rcs(x)

\method{rcs}{vp}(x)

\method{rcs}{list}(x)

\method{rcs}{vpts}(x)

\method{rcs}{vpi}(x)
}
\arguments{
\item{x}{A \code{vp}, list of \code{vp}, \code{vpts} or \code{vpi} object.}
}
\value{
The radar cross section in cm^2.
}
\description{
Returns the currently assumed radar cross section of an object in cm^2.
}
\examples{
# Get the radar cross section for a vp
vp <- example_vp
rcs(vp)

# Get the radar cross section for a vpts
vpts <- example_vpts
rcs(vpts)

# Get the radar cross section for a vpi
vpi <- integrate_profile(example_vpts)
rcs(vpi)
}
\seealso{
\itemize{
\item \code{\link[=rcs<-]{rcs()<-}} for setting the radar cross section of an object.
\item \code{\link[=sd_vvp_threshold]{sd_vvp_threshold()}}
}
}
