% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beam.R
\name{gaussian_beam_profile}
\alias{gaussian_beam_profile}
\title{Gaussian beam profile as a function of height}
\usage{
gaussian_beam_profile(
  height,
  range,
  elev,
  antenna = 0,
  beam_angle = 1,
  k = 4/3,
  lat = 35,
  re = 6378,
  rp = 6357
)
}
\arguments{
\item{height}{Numeric. Height in m.}

\item{range}{Numeric. Slant range, i.e. the length of the skywave path
between target and the radar antenna, in m.}

\item{elev}{Numeric. Beam elevation, in degrees.}

\item{antenna}{Numeric. Height of the centre of the radar antenna, in m.}

\item{beam_angle}{Numeric. Beam opening angle in degrees, typically the
angle between the half-power (-3 dB) points of the main lobe.}

\item{k}{Numeric. Standard refraction coefficient.}

\item{lat}{Numeric. Geodetic latitude of the radar, in degrees.}

\item{re}{Numeric. Earth equatorial radius, in km.}

\item{rp}{Numeric. Earth polar radius, in km.}
}
\value{
numeric.
}
\description{
Normalized altitudinal pattern of radiated energy as a function of altitude
at a given distance from the radar. \code{antenna} and \code{height} should be given in
reference to the same reference plane (e.g. ground level or sea level).
}
\details{
Beam profile is calculated using \link{beam_height} and \link{beam_width}. \code{height} and
\code{antenna} should be given in reference to the same reference plane (e.g. ground level or sea level)
}
\seealso{
Other beam_functions: 
\code{\link{beam_distance}()},
\code{\link{beam_height}()},
\code{\link{beam_profile_overlap}()},
\code{\link{beam_profile}()},
\code{\link{beam_range}()},
\code{\link{beam_width}()}
}
\concept{beam_functions}
\keyword{internal}
