% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cajun.R
\name{read_cajun}
\alias{read_cajun}
\title{Read a vertical profile (\code{vp}) from UMASS Cajun text file}
\usage{
read_cajun(file, rcs = 11, wavelength = "S")
}
\arguments{
\item{file}{Character. Path to a text file containing the standard output
(\code{stdout}) generated by UMASS Cajun pipeline.}

\item{rcs}{Numeric. Radar cross section per bird in cm^2.}

\item{wavelength}{Character or numeric. Radar wavelength, either \code{C} for
C-band (5.3 cm), \code{S} for S-band (10.6 cm) or in cm.}
}
\value{
A \code{vp} object.
}
\description{
Read a vertical profile (\code{vp}) from UMASS Cajun text file
}
\seealso{
\itemize{
\item \code{\link[=summary.vp]{summary.vp()}}
}
}
