
<!-- README.md is generated from README.Rmd. Please edit that file -->

# Bioassays

<!-- badges: start -->

<!-- badges: end -->

'Bioassays' is an R package, designed to provide a wide range of functions relevant to multi-well plate assays. It can handle data from any of the standard multi-well plate format: 6, 12, 24, 96 or 384 well plates. ‘Bioassays’ can help in formatting, visualizing and analyzing multi-well plate data. It has functions for handling outliers, for handling multiple data sets with separate blanks, for estimating values from standard curves, for summarizing data and for doing statistical analysis. Moreover, it is strongly documented in a manner designed to be easy for even beginners to grasp.
## Installation

You can install the released version of bioassays from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("bioassays")
```
The latest development version can be installed from github with the remotes package
``` r
library(remotes)
install_github("anwarbio/bioassays")
```
## Example

Detail’s of various funtions in this package is provided in
‘bioassays-vignette’. Examples on how to use this package is provided
in ‘bioassays-example’ in Vignette.

## Contribute

We love your input! Users may request new features by opening a [GitHub Issue](https://github.com/anwarbio/bioassays/issues), or may contribute their own additions and improvements via a pull request. Similarly, if you run into problems while using this package, or require technical support, do not hesitate to request support through a [GitHub Issue](https://github.com/anwarbio/bioassays/issues). If you use ‘Bioassays’ in your work and would like to further collaborate, I would be more than willing to discuss it over email or [GitHub Issue](https://github.com/anwarbio/bioassays/issues).

