% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_bioint_raster.R
\name{biointRaster}
\alias{biointRaster}
\title{Computation of Bioclimatic Intensities (raster mode)}
\usage{
biointRaster(bb, wout = NULL)
}
\arguments{
\item{bb}{Bioclimatic balance in raster format.}

\item{wout}{name of the output raster. Must include ".tif".}
}
\value{
SpatRaster with 120 layers corresponding to the 12 monthly values of "IBPc","IBCc","IBLc","IBRc","IBSc","IBPf","IBCf","IBLf","IBRf","IBSf".
}
\description{
Computes bioclimatic intensities from bioclimatic balance.
}
\examples{
\donttest{
bb <- terra::rast(bbRast)
bi <- biointRaster(bb, wout=NULL)
}
}
