% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_reg_exp.R
\name{cluster_reg_exp}
\alias{cluster_reg_exp}
\title{Clustering of sequences based on regular expression}
\usage{
cluster_reg_exp(ngrams)
}
\arguments{
\item{ngrams}{list of elements}
}
\value{
List of four
\itemize{
 \item{"regExps"}{regular expression in best clustering}
 \item{"seqClustering"}{clustering of sequences in best clustering}
 \item{"allRegExps"}{all regular expressions.}
 \item{"allIndices"}{all clusterings}
}
}
\description{
Clusters sequences hierarchically with regular expressions.
At each step we minimize number of degrees of freedom for all regular
expressions needed to describe the data
}
\details{
Regular expression is a list of the length equal to the length
of the input sequences. Each element of the list represents a position in 
the sequence and contains amino acid, that are likely to occure on this
position.
}
\examples{
data(human_cleave)
#cluster_reg_exp is computationally expensive
\donttest{
results <- cluster_reg_exp(human_cleave[1L:10, 1L:4])
}
}
