% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listGroups.R
\name{listGroups}
\alias{listGroups}
\title{List number of available genomes in each group}
\usage{
listGroups(db = "refseq", kingdom = "all", details = FALSE)
}
\arguments{
\item{db}{a character string specifying the database for which genome availability shall be checked, 
e.g. \code{db = "refseq"} and \code{db = "genbank"}.}

\item{kingdom}{a kingdom specification retrieved by \code{\link{getKingdoms}}.}

\item{details}{shall all species corresponding to the specified \code{kingdom} be returned? Default is \code{details = FALSE}.}
}
\description{
Users can retrieve the available number of sequenced genomes per group. 
Only available for \code{db = "refseq"} and \code{db = "genbank"}.
}
\examples{
 
\dontrun{
# example for refseq
listGroups(db = "refseq")

# example for genbank
listGroups(db = "genbank")

### in case groups should be specified by kingdom
# first, retrieve available kingdom names
listKingdoms()

# now we choose kingdom "bacteria"
listGroups(db = "refseq", kingdom = "bacteria")

# or 

listGroups(db = "genbank", kingdom = "bacteria")

}

}
\seealso{
\code{\link{listGenomes}}, \code{\link{is.genome.available}}, \code{\link{listKingdoms}}
}
\author{
Hajk-Georg Drost
}
