% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGO.R
\name{getGO}
\alias{getGO}
\title{Gene Ontology Query}
\usage{
getGO(organism, genes, filters, ...)
}
\arguments{
\item{organism}{a character string specifying the scientific name 
of a query organism.}

\item{genes}{a character vector storing the gene ids of a organisms 
of interest to be queried against Ensembl Biomart.}

\item{filters}{a character vector specifying the filter (query key) for 
the Ensembl Biomart query, e.g. \code{filter} = \code{"ensembl_gene_id"}.}

\item{...}{additional parameters that can be passed to the 
\code{\link{biomart}} function.}
}
\description{
This function takes a gene id as character vector from a given 
query organism and returns the corresponding GO terms and additional GO 
information.
}
\details{
This function takes the scientific name of a query organism, a set of genes 
for which GO terms and additional information shall be retrieved, and a 
filter argument that specifies the attribute for the query genes.
}
\examples{
\dontrun{ 
GO_tbl <- getGO(organism = "Arabidopsis thaliana", 
                genes    = c("AT1G06090", "AT1G06100"),
                filters  = "ensembl_gene_id")

# look at the result
head(GO_tbl)
}
}
\seealso{
\code{\link{biomart}}, \code{\link{organismFilters}}, 
\code{\link{organismBM}}, \code{\link[biomaRt]{getBM}}, 
\code{\link{getMarts}}, \code{\link{getDatasets}}, 
\code{\link{getFilters}}
}
\author{
Hajk-Georg Drost
}
