## ---- echo = FALSE, message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
options(width = 750)
knitr::opts_chunk$set(
  comment = "#>",
  error = FALSE,
  tidy = FALSE)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # load the biomartr package
#  library(biomartr)
#  
#  # list all available databases
#  getMarts()

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  head(getDatasets(mart = "ENSEMBL_MART_ENSEMBL") , 5)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  tail(getDatasets(mart = "ENSEMBL_MART_ENSEMBL") , 38)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # list all available attributes for dataset: hsapiens_gene_ensembl
#  head( getAttributes(mart    = "ENSEMBL_MART_ENSEMBL",
#                      dataset = "hsapiens_gene_ensembl"), 10 )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # list all available filters for dataset: hsapiens_gene_ensembl
#  head( getFilters(mart    = "ENSEMBL_MART_ENSEMBL",
#                   dataset = "hsapiens_gene_ensembl"), 10 )

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # retrieving all available datasets and biomart connections for
#  # a specific query organism (scientific name)
#  organismBM(organism = "Homo sapiens")

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # return available attributes for "Homo sapiens"
#  head(biomartr::organismAttributes("Homo sapiens"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # search for attribute topic "id"
#  head(organismAttributes("Homo sapiens", topic = "id"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # search for attribute topic "homolog"
#  head(organismAttributes("Homo sapiens", topic = "homolog"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # search for attribute topic "dn"
#  head(organismAttributes("Homo sapiens", topic = "dn"))

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # search for attribute topic "ds"
#  head(organismAttributes("Homo sapiens", topic = "ds"))

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # return available filters for "Homo sapiens"
#  head(organismFilters("Homo sapiens"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # search for filter topic "id"
#  head(organismFilters("Homo sapiens", topic = "id"), 20)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  
#  head(organismAttributes("Homo sapiens", topic = "id"))

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # retrieve the proteome of Homo sapiens from refseq
#  file_path <- getProteome( db       = "refseq",
#                            organism = "Homo sapiens",
#                            path     = file.path("_ncbi_downloads","proteomes") )
#  
#  Hsapiens_proteome <- read_proteome(file_path, format = "fasta")
#  
#  # remove splice variants from id
#  gene_set <- unlist(sapply(strsplit(Hsapiens_proteome@ranges@NAMES[1:5], ".",fixed = TRUE), function(x) x[1]))
#  
#  result_BM <- biomart( genes      = gene_set,
#                        mart       = "ENSEMBL_MART_ENSEMBL",
#                        dataset    = "hsapiens_gene_ensembl",
#                        attributes = c("ensembl_gene_id","ensembl_peptide_id"),
#                        filters    = "refseq_peptide")
#  
#  result_BM

## ----eval=FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  # show all elements of the data.frame
#  options(tibble.print_max = Inf)
#  # search for GO terms of an example Homo sapiens gene
#  GO_tbl <- getGO(organism = "Homo sapiens",
#                  genes    = "GUCA2A",
#                  filters  = "hgnc_symbol")
#  
#  GO_tbl

