% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGFF.R
\name{getGTF}
\alias{getGTF}
\title{Genome Annotation Retrieval (GTF)}
\usage{
getGTF(
  db = "ensembl",
  organism,
  remove_annotation_outliers = FALSE,
  path = file.path("ensembl", "annotation"),
  release = NULL,
  mute_citation = FALSE
)
}
\arguments{
\item{db}{a character string specifying the database from which the genome
shall be retrieved:
\itemize{
\item \code{db = "refseq"}
\item \code{db = "genbank"}
\item \code{db = "ensembl"}
}}

\item{organism}{Organism selector id,
there are three options to characterize an organism:
\itemize{
\item by \code{scientific name}: e.g. \code{organism = "Homo sapiens"}
\item by \code{database specific accession identifier}: e.g. \code{organism = "GCF_000001405.37"} (= NCBI RefSeq identifier for \code{Homo sapiens})
\item by \code{taxonomic identifier from NCBI Taxonomy}: e.g. \code{organism = "9606"} (= taxid of \code{Homo sapiens})
}}

\item{remove_annotation_outliers}{shall outlier lines be removed from the input \code{annotation_file}?
If yes, then the initial \code{annotation_file} will be overwritten and the removed outlier lines will be stored at \code{\link{tempdir}}
for further exploration.}

\item{path}{a character string specifying the location (a folder) in which
the corresponding annotation file shall be stored. Default is
\code{path = file.path("_ncbi_downloads","annotation")}.}

\item{release}{a numeric, the database release version of ENSEMBL (\code{db = "ensembl"}). Default is \code{release = NULL} meaning
that the most recent database version is used. \code{release = 75} would for human would give the stable
GRCh37 release in ensembl. Value must be > 46, since ensembl did not structure their data
if the standard format before that.}

\item{mute_citation}{logical, default FALSE, indicating whether citation message should be muted.}
}
\value{
File path to downloaded genome.
}
\description{
Main retrieval function for GTF files of an
organism of interest. By specifying the scientific name of an organism of
interest the corresponding GTF file storing the annotation  for the organism
of interest can be downloaded and stored locally. GTF files can be retrieved
from several databases.
}
\details{
Internally this function loads the the overview.txt file from NCBI:

 refseq: ftp://ftp.ncbi.nlm.nih.gov/genomes/refseq/

 genbank: ftp://ftp.ncbi.nlm.nih.gov/genomes/genbank/

and creates a directory relative to file type, if you get fasta genomes it will be
_ncbi_downloads/genomes'.
In case the corresponding fasta file already exists within the
'_ncbi_downloads/genomes' folder and is accessible within the workspace,
no download process will be performed.
For other file types the same rule applies.
}
\examples{
\dontrun{
# download the annotation of Homo sapiens from ensembl
# and store the corresponding genome file in 'ensembl/annotation'
getGTF(db            = "ensembl",
       organism      = "Homo sapiens",
       path          = file.path("ensembl","annotation"))

getGTF(db            = "ensembl",
       organism      = "Homo sapiens",
       path          = file.path("ensembl","annotation"),
       assembly_type = "primary_assembly")

}

}
\seealso{
Other getBio: 
\code{\link{getBio}()},
\code{\link{getCDS}()},
\code{\link{getCollection}()},
\code{\link{getGenome}()},
\code{\link{getProteome}()},
\code{\link{getRNA}()}

Other gff: 
\code{\link{getGFFSet}()},
\code{\link{read_gff}()}
}
\author{
Hajk-Georg Drost
}
