% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\docType{import}
\name{autoplot}
\alias{autoplot}
\alias{reexports}
\alias{autoplot.mct}
\alias{autoplot.design}
\title{Automatic plots for objects generated in biometryassist}
\usage{
\method{autoplot}{mct}(
  object,
  size = 4,
  label_height = 0.1,
  rotation = 0,
  axis_rotation = rotation,
  label_rotation = rotation,
  ...
)

\method{autoplot}{design}(
  object,
  rotation = 0,
  size = 4,
  margin = FALSE,
  palette = "default",
  row = NULL,
  col = NULL,
  block = NULL,
  ...
)
}
\arguments{
\item{object}{An object to create a plot for. Currently objects from the \code{\link[=multiple_comparisons]{multiple_comparisons()}} or \code{\link[=design]{design()}} functions with class "mct" or "design" respectively are supported.}

\item{size}{Increase or decrease the text size within the plot for treatment labels. Numeric with default value of 4.}

\item{label_height}{Height of the text labels above the upper error bar on the plot. Default is 0.1 (10\%) of the difference between upper and lower error bars above the top error bar. Values > 1 are interpreted as the actual value above the upper error bar.}

\item{rotation}{Rotate the x axis labels and the treatment group labels within the plot. Allows for easier reading of long axis or treatment labels. Number between 0 and 360 (inclusive) - default 0}

\item{axis_rotation}{Enables rotation of the x axis independently of the group labels within the plot.}

\item{label_rotation}{Enables rotation of the treatment group labels independently of the x axis labels within the plot.}

\item{...}{Arguments passed to methods.}

\item{margin}{Logical (default \code{FALSE}). A value of \code{FALSE} will expand the plot to the edges of the plotting area i.e. remove white space between plot and axes.}

\item{palette}{A string specifying the colour scheme to use for plotting. Default is equivalent to "Spectral". Colour blind friendly palettes can also be provided via options \code{"colour blind"} (or \code{"color blind"}, both equivalent to \code{"viridis"}), \code{"magma"}, \code{"inferno"}, \code{"plasma"} or \code{"cividis"}. Other palettes from \code{\link[scales:brewer_pal]{scales::brewer_pal()}} are also possible.}
}
\value{
A \code{ggplot2} object.
}
\examples{
dat.aov <- aov(Petal.Width ~ Species, data = iris)
output <- multiple_comparisons(dat.aov, classify = "Species")
autoplot(output, label_height = 0.5)
des.out <- design(type = "crd", treatments = c(1, 5, 10, 20),
                  reps = 5, nrows = 4, ncols = 5, seed = 42, plot = FALSE)
autoplot(des.out)

# Colour blind friendly colours
autoplot(des.out, palette = "colour-blind")

# Alternative colour scheme
autoplot(des.out, palette = "plasma")
}
\seealso{
\code{\link[=multiple_comparisons]{multiple_comparisons()}} and \code{\link[=design]{design()}}
}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{ggplot2}{\code{\link[ggplot2]{autoplot}}}
}}

