% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{heat_map}
\alias{heat_map}
\title{Heatmap}
\usage{
heat_map(
  data,
  value,
  x_axis,
  y_axis,
  grouping = NULL,
  raster = TRUE,
  smooth = FALSE,
  palette = "default"
)
}
\arguments{
\item{data}{A data frame containing the data to be plotted}

\item{value}{A column of \code{data}, containing the values that vary over the space which produces the colours}

\item{x_axis}{The column of \code{data} to use as the x axis data.}

\item{y_axis}{The column of \code{data} to use as the y axis data.}

\item{grouping}{An optional grouping variable to facet the plot by.}

\item{raster}{Logical (default: \code{TRUE}). If \code{TRUE} uses \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}} for speed. Will not work if the grid is irregular.}

\item{smooth}{Logical (default: \code{TRUE}). If \code{raster} is \code{TRUE}, interpolation can be applied across the grid to obtain a smoothed grid. Ignored if \code{raster} is \code{FALSE}.}

\item{palette}{Colour palatte to use. By default it will use the \code{viridis} (colour-blind friendly) palette. Other palettes available can be seen with \code{\link[grDevices:palettes]{grDevices::hcl.pals()}}.}
}
\value{
A \code{ggplot2} object.
}
\description{
Function to plot heatmaps of variables in a grid layout.
}
\examples{

set.seed(42)
dat <- expand.grid(x = 1:5, y = 1:6)
dat$value <- rnorm(30)
dat$groups <- sample(rep(LETTERS[1:6], times = 5))

heat_map(dat, value, x, y)
heat_map(dat, "value", "x", "y", "groups")
}
