% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SampleMat2.R
\name{SampleMat2}
\alias{SampleMat2}
\title{Sample binary vector}
\usage{
SampleMat2(ref, ratio, as.logi = FALSE)
}
\arguments{
\item{ref}{a binary vector}

\item{ratio}{the proportion of \code{ref} to sample}

\item{as.logi}{logical, if FALSE (default) id of cell will be return;
if TRUE, logical vector of same length than ref will be return}
}
\value{
A list of 2 elements is returned :

- `calibration` Ids of cells selected for calibration (1st sample)

- `evaluation` Ids of cells selected for evaluation (1st sample
  complementary)
}
\description{
\code{SampleMat2} is an internal \pkg{biomod2} function that can help
user to sample a binary vector keeping the same proportion of 0s and 1s
than in the initial vector.
}
\details{
This function can be useful to help users to select a part of initial
dataset that will be only kept for all validation procedures.
}
\examples{
a <- sample(c(0,1),100, replace=TRUE)
SampleMat2(ref=a, ratio=0.7)

}
\seealso{
\code{\link[biomod2]{BIOMOD_FormatingData}}
}
\author{
Damien Georges
}
\keyword{formula}
\keyword{models}
\keyword{options}
