% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netclu_beckett.R
\name{netclu_beckett}
\alias{netclu_beckett}
\title{Community structure detection in weighted bipartite network via modularity
optimization}
\usage{
netclu_beckett(
  net,
  weight = TRUE,
  cut_weight = 0,
  index = names(net)[3],
  seed = NULL,
  forceLPA = FALSE,
  site_col = 1,
  species_col = 2,
  return_node_type = "both",
  algorithm_in_output = TRUE
)
}
\arguments{
\item{net}{a \code{data.frame} representing a bipartite network with the two
first columns as undirected links between pair of nodes and and the next
column(s) are the weight of the links.}

\item{weight}{a \code{boolean} indicating if the weights should be considered
if there are more than two columns (see Note).}

\item{cut_weight}{a minimal weight value. If \code{weight} is TRUE, the links
between sites with a weight strictly lower than this value will not be
considered (O by default).}

\item{index}{name or number of the column to use as weight. By default,
the third column name of \code{net} is used.}

\item{seed}{for the random number generator (NULL for random by default).}

\item{forceLPA}{a \code{boolean} indicating if the even faster pure
LPA-algorithm of Beckett should be used? DIRT-LPA, the default, is less
likely to get trapped in a local minimum, but is slightly slower. Defaults
to FALSE.}

\item{site_col}{name or number for the column of site nodes (i.e. primary
nodes).}

\item{species_col}{name or number for the column of species nodes (i.e.
feature nodes).}

\item{return_node_type}{a \code{character} indicating what types of nodes
(\code{site}, \code{species} or \code{both}) should be returned in the output
(\code{return_node_type = "both"} by default).}

\item{algorithm_in_output}{a \code{boolean} indicating if the original output
of \link[bipartite:computeModules]{computeModules} should be returned in the
output (\code{TRUE} by default, see Value).}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five slots:
\enumerate{
\item{\strong{name}: \code{character} containing the name of the algorithm}
\item{\strong{args}: \code{list} of input arguments as provided by the user}
\item{\strong{inputs}: \code{list} of characteristics of the clustering process}
\item{\strong{algorithm}: \code{list} of all objects associated with the
clustering procedure, such as original cluster objects (only if
\code{algorithm_in_output = TRUE})}
\item{\strong{clusters}: \code{data.frame} containing the clustering results}}

In the \code{algorithm} slot, if \code{algorithm_in_output = TRUE}, users can find the
output of \link[bipartite:computeModules]{computeModules}.
}
\description{
This function takes a bipartite weighted graph and computes modules by
applying Newman’s modularity measure in a bipartite weighted version to it.
}
\details{
This function is based on the modularity optimization algorithm provided by
Stephen Beckett \insertCite{Beckett2016}{bioregion} as implemented in the
\href{https://cran.r-project.org/package=bipartite}{bipartite}
package (\link[bipartite:computeModules]{computeModules}).
}
\note{
Beckett has been designed to deal with weighted bipartite networks. Note
that if \code{weight = FALSE}, a weight of 1 will be assigned to each pair of
nodes. Do not forget to indicate which of the first two columns is
dedicated to the site nodes (i.e. primary nodes) and species nodes (i.e.
feature nodes) using the arguments \code{site_col} and \code{species_col}. The type of
nodes returned in the output can be chosen with the argument
\code{return_node_type} equal to \code{both} to keep both types of nodes,\code{sites}
to preserve only the sites nodes and \code{species} to preserve only the
species nodes.
}
\examples{
net <- data.frame(
  Site = c(rep("A", 2), rep("B", 3), rep("C", 2)),
  Species = c("a", "b", "a", "c", "d", "b", "d"),
  Weight = c(10, 100, 1, 20, 50, 10, 20))

com <- netclu_beckett(net)

}
\references{
\insertRef{Beckett2016}{bioregion}
}
\seealso{
\link{netclu_infomap}, \link{netclu_oslom}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr}),
Pierre Denelle (\email{pierre.denelle@gmail.com}) and
Boris Leroy (\email{leroy.boris@gmail.com})
}
