% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_box.R
\name{plot_box}
\alias{plot_box}
\title{Create Simple Professional Box Plots}
\usage{
plot_box(
  data,
  x,
  y,
  group = NULL,
  facet = NULL,
  colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  legend_title = NULL,
  points = FALSE,
  point_size = 2,
  y_limits = NULL,
  show_mean = TRUE
)
}
\arguments{
\item{data}{A dataframe containing the variables to plot.}

\item{x}{Character string specifying the x-axis variable.}

\item{y}{Character string specifying the y-axis variable.}

\item{group}{Character string specifying grouping variable for fill/color. Default: NULL.}

\item{facet}{Character string specifying faceting variable. Default: NULL.}

\item{colors}{Character vector of colors. If NULL, uses TealGrn palette. Default: NULL.}

\item{title}{Character string for plot title. Default: NULL.}

\item{xlab}{Character string for x-axis label. Default: NULL.}

\item{ylab}{Character string for y-axis label. Default: NULL.}

\item{legend_title}{Character string for legend title. Default: NULL.}

\item{points}{Logical parameter indicating if jittered points. Default: FALSE.}

\item{point_size}{Numeric value indicating the size of points. Default: 2.}

\item{y_limits}{Numeric vector of length 2 for y-axis limits. Default: NULL.}

\item{show_mean}{Logical parameter indicating if mean should be shown. Default: TRUE.}
}
\value{
A ggplot2 object
}
\description{
Generates publication-ready boxplots with optional jittered points and mean overlay.
}
\examples{
#Simulated clinical data
clinical_df <- clinical_data(visits = 10)

# Boxplot of biomarker by treatment
plot_box(clinical_df, x = "treatment", y = "biomarker", group = "treatment")

# Barplot of bimarker by study visit and treatment
plot_box(clinical_df, x = "visit", y = "biomarker", group = "treatment")

}
