% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Matrix2DF.R
\name{Matrix2DF}
\alias{Matrix2DF}
\title{Convert a bipartite-style matrix to dataframe}
\usage{
Matrix2DF(Matrix, PrimaryLab = "Primary", SecondaryLab = "Secondary",
  SiteLab = "Site")
}
\arguments{
\item{Matrix}{Bipartite network in matrix format}

\item{PrimaryLab}{Label for the primary level of the bipartite web, e.g. 'Plants'}

\item{SecondaryLab}{Label for the secondary level of the bipartite web, e.g. 'Pollinators'}

\item{SiteLab}{Name for the site}
}
\value{
A data.frame where the first column is the primary interactor, the second the secondary
interactor and third column detail the link strengths.
}
\description{
Matrix2DF returns a data frame in the format internally required for bipartiteD3 where the first
two columns list the interacting species, and the third column lists the link strengths.
}
\details{
Matrix2DF expects a matrix of the format used by bipartite, for example that created by frame2webs().
This structure includes row and column names to indicate the species, and a named
third dimension giving the name of that site.

Note a matrix of this format can be passed directly to bipartite_D3() since it will test for a matrix
and apply Matrix2DF() anyway.
}
\examples{

data(Safariland, package='bipartite')
Matrix2DF(Safariland)

}
