% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{classify}
\alias{classify}
\title{Classify samples into classes}
\usage{
classify(
  bp,
  classify.regions = TRUE,
  col = ez.col,
  opacity = 0.4,
  borders = FALSE
)
}
\arguments{
\item{bp}{an object of class \code{biplot}}

\item{classify.regions}{a logical value indicating whether classifications regions should be
shown in the biplot, with default \code{TRUE}.}

\item{col}{the colours of the classification regions}

\item{opacity}{the opacity levels of the classification regions}

\item{borders}{the border colours of the classification regions}
}
\value{
A list object called \code{classify} appended to the object of class \code{biplot} with the following elements:
\item{table}{the confusion matrix resulting from the classification into classes.}
\item{rate}{the classification accuracy rate.}
\item{classify.regions}{a logical value indicating whether classification regions are shown in the biplot.}
\item{aes}{a list of chosen aesthetics for the colours, opacity levels and border colours of the classification regions.}
}
\description{
Classify samples into classes
}
\examples{
biplot(iris[,1:4],classes = iris[,5]) |> CVA() |> axes(col="black") |> 
  classify(col=c("red","blue","orange"),opacity=0.1) |> plot()
}
