% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kCompute.R
\name{kCompute}
\alias{kCompute}
\title{Use sparse grid quadrature techniques to integrate (unnormalized) densities}
\usage{
kCompute(f, init, method = "BFGS", maxit = 10000, level = 2,
  log = FALSE, link = NULL, linkparams = NULL, quadError = FALSE,
  ...)
}
\arguments{
\item{f}{(Unnormalized) density to integrate.
the function \eqn{f} should include an argument \code{log}, 
which returns \eqn{log(f(x))}.}

\item{init}{Initial guess for the density's mode}

\item{method}{method to be used to search for the density's mode}

\item{maxit}{maximum number of iterations \code{optim} should use in 
searching for the density's mode}

\item{level}{accuracy level (typically number of grid points for the 
underlying 1D quadrature rule) [description from mvQuad::createNIGrid]}

\item{log}{TRUE to return log of integration constant}

\item{link}{character vector that specifies transformations used during 
optimization and integration of f(theta2 | X).  while theta2 may be 
defined on arbitrary support, \code{wtdMix} performs optimization and 
integration of theta2 on an unconstrained support.  the \code{link} 
vector describes the transformations that must be applied to each 
element of theta2.  Jacobian functions for the transformations will 
automatically be added to the optimization and integration routines.
currently supported link functions are 'log', 'logit', and 'identity'.}

\item{linkparams}{Optional list of additional parameters  for link functions.
For example, the logit function can be extended to allow mappings to any 
closed interval.  There should be one list entry for each link function.  
Specify NA if no additional arguments are passed.}

\item{quadError}{TRUE if integration nodes and weight should be computed for
the \code{level-1} integration grid, so that quadrature approximation
error can be estimated.}

\item{...}{additional arguments to pass to \code{f}}
}
\description{
This function integrates (unnormalized) densities and may be used to compute
integration constants for unnormalized densities, or to marginalize a 
joint density, for example.
}
\examples{
kCompute(dgamma, init = 1, shape=2, link='log', level = 5)

}
