% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpfun.R
\encoding{UTF-8}
\name{hpfun}
\alias{hpfun}
\title{Hyper-prior function}
\usage{
hpfun(hpf = "Uniform", hp.pars = c(1, 2), ...)
}
\arguments{
\item{hpf}{name of a density function. Supported density functions are: Uniform, Gamma and Normal (abbreviations are not supported)}

\item{hp.pars}{a vector of density function parameters}

\item{...}{additional parameters that can be passed to a density function}
}
\value{
A hyper-prior density function (of class "function")
}
\description{
This function creates a hyper-prior density function. 
Currently supported density function are Uniform, Gamma and Normal. 
The resulting function is used during MCMC \code{\link{mcmc_bite}}
to estimate parameters of priors.
}
\details{
There are three currently implemented density function: 
Uniform, Gamma and Normal. Each of these densities requires two input parameters and hp.pars 
must be a vector of two values and cannot be left empty.
}
\examples{
my.hp <- hpfun(hpf="Uniform", hp.pars=c(1,2))

}
\author{
Anna Kostikova and Daniele Silvestro
}
