% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_test.R
\name{zi_test}
\alias{zi_test}
\title{He's (2019) test for zero-modification}
\usage{
zi_test(model, alternative = "inflated")
}
\arguments{
\item{model}{A model object of class \code{\link{bizicount}} or \code{\link{glm}}.
If a \code{bizicount} model, then at least one margin must be specified as \code{"pois"}.
If a \code{glm} model, then the \code{family} must be \code{\link{poisson}}.}

\item{alternative}{The alternative hypothesis. One of \code{c("inflated", "deflated", "both")}.
These correspond to an upper tail, lower tail, or two-tailed test, respectively.
Default is \code{"inflated"}. Partial matching supported.}
}
\description{
This is an implementation of He et al. (2019)'s test for
zero-modification (discussed further in Tang & Tang (2019)). This is a test of
zero-\emph{modification} instead of \emph{inflation}, because the test is capable of detecting
both excessive or lack of zeros, but cannot determine the cause. For example, a mixed
data generating process could be generating structural zeros, implying a
zero-inflated distribution. However, overdispersion via a negative binomial
may also result in excessive zeros. Thus, the test merely determines whether
there are excessive (or lacking) zeros, but does not determine the process
generating this pattern. That in mind, typical tests in the literature are
inappropriate for zero-modified regression models, namely the Vuong, Wald,
score, and likelihood ratio tests. See the references below for more information
on this claim.
}
\details{
The test compares the
observed proportion of zeros in the data to the expected proportion of zeros
under the null hypothesis of a Poisson distribution. This is done using
estimating equations to account for the fact that the expected proportion is
based on an estimated parameter vector, rather than the true parameter vector.
The test statistic is

\eqn{\hat s = 1/n\sum_i (r_i - \hat p_i)}

where \eqn{r_i = 1} if \eqn{y_i = 0}, otherwise \eqn{r_i = 0}, and \eqn{\hat p = dpois(0, exp(X\hat\beta)) = \hat E(r_i)}
is the estimated proportion of zeros under the assumption of a Poisson distribution
generated with covariates \eqn{X} and parameter vector \eqn{\hat\beta}.

By the central limit theorem, \eqn{\hat s \sim AN(0, \sigma^2_s)}. However,
estimating \eqn{\hat \sigma_s} by a plug-in estimate using \eqn{\hat\beta} is inefficient
due to \eqn{\hat \beta} being an random variable with its own variance. Thus,
\eqn{\hat\sigma} is estimated via estimating equations in order to account for the
variance in \eqn{\hat \beta}.

See the references below for more discussion and proofs.
}
\examples{
set.seed(123)
n = 500
u = rpois(n, 3)
y1 = rzip(n, 12, .2) + u
y2 = rpois(n, 8) + u

# Single parameter test, covariates can be added though.
uni1 = glm(y1 ~ 1, family = poisson())
uni2 = glm(y2 ~ 1, family = poisson())

biv = bizicount(y1~1, y2~1, margins = c("pois", "pois"), keep = TRUE)

zi_test(uni1)
zi_test(uni2)

zi_test(biv)
}
\references{
He, H., Zhang, H., Ye, P., & Tang, W. (2019). A test of inflated
zeros for Poisson regression models. Statistical methods in medical research,
28(4), 1157-1169.

Tang, Y., & Tang, W. (2019). Testing modified zeros for Poisson regression
models. Statistical Methods in Medical Research, 28(10-11), 3123-3141.
}
\author{
John Niehaus
}
