% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputePostmeanHnew.R
\name{ComputePostmeanHnew.approx}
\alias{ComputePostmeanHnew.approx}
\title{Compute the posterior mean and variance of \code{h} at a new predictor values}
\usage{
ComputePostmeanHnew.approx(
  fit,
  y = NULL,
  Z = NULL,
  X = NULL,
  Znew = NULL,
  sel = NULL
)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{Znew}{matrix of new predictor values at which to predict new \code{h}, where each row represents a new observation. If set to NULL then will default to using the observed exposures Z.}

\item{sel}{logical expression indicating samples to keep; defaults to keeping the second half of all samples}
}
\description{
Function to approximate the posterior mean and variance as a function of the estimated model parameters (e.g., tau, lambda, beta, and sigsq.eps)
}
