% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose_email.R
\name{compose_email}
\alias{compose_email}
\title{Create the email message body}
\usage{
compose_email(body = NULL, header = NULL, footer = NULL,
  title = NULL)
}
\arguments{
\item{header, body, footer}{The three layout sections for an email message
(ordered from top to bottom). Markdown text can be supplied to each of
these by using the \code{\link[=md]{md()}} text helper function. Alternatively, we can
supply a set of \code{block_*()} calls enclosed within the \code{\link[=blocks]{blocks()}} function
to take advantage of precomposed HTML blocks.}

\item{title}{The title of the email message. This is not the subject but the
HTML title text which may appear in limited circumstances.}
}
\value{
An \code{email_message} object.
}
\description{
The \code{compose_email()} function allows us to easily create an email message.
We can incorporate character vectors into the message body, the header, or
the footer.
}
\examples{
# Create a simple email message using
# Markdown-formatted text in the `body`
# and `footer` sections with the `md()`
# text helper function
email <-
  compose_email(
    body = md(
"
## Hello!

This is an email message that was generated by the blastula package.

We can use **Markdown** formatting with the `md()` function.

Cheers,

The blastula team
"),
  footer = md(
"
sent via the [blastula](https://rich-iannone.github.io/blastula) R package
")
)

# The email message can always be
# previewed by calling the object
if (interactive()) email

}
