% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_readable_time.R
\name{add_readable_time}
\alias{add_readable_time}
\title{Create a string with a more readable date/time}
\usage{
add_readable_time(time = NULL, use_date = TRUE, use_time = TRUE, use_tz = TRUE)
}
\arguments{
\item{time}{The \code{POSIXct} time to use, and to make more readable for email
recipients. If a \code{time} is not provided (the default), the current system
time will be used.}

\item{use_date, use_time, use_tz}{Logical value that indicate whether to
include the date, time, or time zone components.}
}
\value{
A character object that can be placed inside any message component
message wherever the function is called.
}
\description{
Add a nicely-formatted date/time string inside the body of the email with
this helper function. We can provide a \code{POSIXct} date-time object or use the
current date/time/tz (based on the user's locale information at the time of
the function call). There are options to specify whether the date, time, and
time zone parts are to be included.
}
\examples{

# Generate a date and time value using a specified date/time value
add_readable_time(
  time = ISOdatetime(
    year = 2022,
    month = 3,
    day = 15,
    hour = 8,
    min = 30,
    sec = 0,
    tz = "GMT"
   ),
  use_tz = FALSE
)

}
