% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student.R
\name{adjusted_alpha,Student-method}
\alias{adjusted_alpha,Student-method}
\title{Adjusted level of significance}
\usage{
\S4method{adjusted_alpha}{Student}(design, n1, nuisance, tol, iters = 10000, seed = NULL, ...)
}
\arguments{
\item{design}{Object of class \code{Student} created by \code{setupStudent}.}

\item{n1}{Either the sample size of the first stage (if
\code{recalculation = TRUE} or the toal sample size (if
\code{recalculation = FALSE}).}

\item{nuisance}{Value of the nuisance parameter. For the
Student's t-test this is the variance.}

\item{tol}{desired absolute tolerance}

\item{iters}{Number of simulation iterations.}

\item{seed}{Random seed for simulation.}

\item{...}{Further optional arguments.}
}
\value{
Value of the adjusted significance level for every nuisance
 parameter and every value of n1.
}
\description{
This method returns an adjusted significance level that can be used
such that the actual type I error rate is preserved.
}
\details{
The method is only vectorized in either \code{nuisance}
  or \code{n1}.

In the case of the Student's t-test, the adjusted alpha is
calculated using the algorithm by Kieser and Friede (2000):
"Re-calculating the sample size in internal pilot study designs
with control of the type I error rate". Statistics in Medicine 19: 901-911.
}
\examples{
d <- setupStudent(alpha = .025, beta = .2, r = 1, delta = 0, delta_NI = 1.5,
                  n_max = 848)
sigma <- c(2, 5.5, 9)
adjusted_alpha(design = d, n1 = 20, nuisance = sigma, tol = 1e-4, iters = 1e3)

}
