% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulate_Data.R
\name{sim_x}
\alias{sim_x}
\title{sim_x}
\usage{
sim_x(param)
}
\arguments{
\item{param}{a list containing :
\describe{
 \item{grid}{a numerical vector, the observation times.}
 \item{n}{an integer, the sample size.}
 \item{p}{an integer, the number of observation times.}
 \item{diagVar}{a numerical vector (optional), the diagonal of the autocorrelation matrix.}
 \item{dim}{a numerical value (optional), the dimension of the Fourier basis,
            if "shape" is "Fourier" or "Fourier2". }
 \item{ksi}{a numerical value (optional) related to the observations correlation.}
 \item{x_shape}{a character vector (optional), the shape of the observations. }
}}
}
\value{
a matrix which contains the functional covariate observations at time
        points given by \code{grid}.
}
\description{
Simulate functional covariate observations.
}
\details{
Several shape are available for the observations: "Fourier",
         "Fourier2", "random_walk", "random_sharp", "uniform", "gaussian",
         "mvgauss", "mvgauss_different_scale", "mvgauss_different_scale2",
         "mvgauss_different_scale3" and "mvgauss_different_scale4".
}
\examples{
library(RColorBrewer)
### Fourier
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_shape="Fourier")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
### Fourier2
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_type="Fourier2")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
### random_walk
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_type="random_walk")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
### random_sharp
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_type="random_sharp")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
### uniform
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_type="uniform")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
### gaussian
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_type="gaussian")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
### mvgauss
param <- list(n=15,p=100,grid=seq(0,1,length=100),x_type="mvgauss")
x <- sim_x(param)
cols <- colorRampPalette(brewer.pal(9,"YlOrRd"))(15)
matplot(param$grid,t(x),type="l",lty=1,col=cols)
}
