% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{change_grid}
\alias{change_grid}
\title{change_grid}
\usage{
change_grid(fct, grid, new_grid)
}
\arguments{
\item{fct}{a numerical vector, the function to evaluate on the new grid.}

\item{grid}{a numerical vector, the initial grid.}

\item{new_grid}{a numerical vector, the new grid.}
}
\value{
a numerical vector, the approximation of the function on the new grid.
}
\description{
Compute a function (evaluated on a grid) on a given (finer) grid.
}
\examples{
grid <- seq(0,1,l=1e1)
new_grid <- seq(0,1,l=1e2)
fct <- 3*grid^2 + sin(grid*2*pi)
plot(grid,fct,type="o",lwd=2,cex=1.5)
lines(new_grid,change_grid(fct,grid,new_grid),type="o",col="red",cex=0.8)
}
