% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explorer.R
\name{foldExplorer}
\alias{foldExplorer}
\title{Explore the generated folds}
\usage{
foldExplorer(blocks, rasterLayer, speciesData)
}
\arguments{
\item{blocks}{An SpatialBlock, EnvironmentalBlock or BufferedBlock object.}

\item{rasterLayer}{A raster object as background map for visualisation.}

\item{speciesData}{A simple features (sf) or SpatialPoints object containing species data (response variable).}
}
\value{
An interactive map showing folds and the species data, that can be used  to explore folds. Note that this can also
be opened in a web browser window. When you return to the R console, press "Esc" to return to the prompt.
}
\description{
A function for visualising the generated folds on a map, and allowing interactive exploration of the data in the folds,
using the \pkg{RStudio Shiny} app.
}
\examples{
\donttest{
if(interactive()){

# load package data
awt <- raster::brick(system.file("extdata", "awt.grd", package = "blockCV"))
# import presence-absence species data
PA <- read.csv(system.file("extdata", "PA.csv", package = "blockCV"))
# make a sf object from data.frame
pa_data <- sf::st_as_sf(PA, coords = c("x", "y"), crs = raster::crs(awt))

# spatial blocking by specified range and random assignment
sb <- spatialBlock(speciesData = pa_data,
                   species = "Species",
                   rasterLayer = awt,
                   theRange = 70000,
                   k = 5,
                   selection = "random",
                   iteration = 100)

foldExplorer(sb, awt, pa_data)

# buffering with presence-absence data
bf <- buffering(speciesData= pa_data,
                species= "Species", # to count the number of presences and absences
                theRange= 70000,
                spDataType = "PA",
                progress = TRUE)

foldExplorer(bf, awt, pa_data)

# environmental clustering
eb <- envBlock(rasterLayer = awt,
               speciesData = pa_data,
               species = "Species",
               k = 5)

foldExplorer(eb, awt, pa_data)

}
}

}
\seealso{
\code{\link{spatialBlock}}, \code{\link{buffering}} and \code{\link{envBlock}}
}
