% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lattice.R
\name{lattices}
\alias{lattices}
\title{Mutually orthogonal latin square arrays of zize v}
\usage{
lattices(v, u)
}
\arguments{
\item{v}{the dimension of the required MOLS}

\item{u}{equals r-2 where r is the replication number}
}
\value{
\item{Treatments}{A table showing the replication number of each treatment in the design.}
}
\description{
Constructs a lattice treatment design for internal use by the \code{blocksdesign} algorithm
Use \code{blocksdesign::MOLS} for stand-alone construction of MOLS.
}
\details{
Returns a data frame for V*v treatments allocating treatments to blocks assuming a lattice design with r
 complete replicate blocks and blocks of size v. Returns a simple lattice for r=2 or a triple lattice for 
 r=3 for any size of v. Returns a lattice for any r < v + 2 if v is prime or any prime power where 
 primes=c(2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97) 
 powers=c(12,7,5,4,3,3,3,3,rep(2,17))
 Returns a triple lattice for v=10 and r=4
}
