% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-plots.R
\name{blr_plot_deviance_fitted}
\alias{blr_plot_deviance_fitted}
\title{Deviance vs fitted values plot}
\usage{
blr_plot_deviance_fitted(model, point_color = "blue", line_color = "red",
  title = "Deviance Residual vs Fitted Values",
  xaxis_title = "Fitted Values", yaxis_title = "Deviance Residual")
}
\arguments{
\item{model}{An object of class \code{glm}.}

\item{point_color}{Color of the points.}

\item{line_color}{Color of the horizontal line.}

\item{title}{Title of the plot.}

\item{xaxis_title}{X axis label.}

\item{yaxis_title}{Y axis label.}
}
\description{
Deviance vs fitted values plot.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
family = binomial(link = 'logit'))

blr_plot_deviance_fitted(model)

}
