% Generated by roxygen2 (4.0.0): do not edit by hand
\name{buildDh}
\alias{buildDh}
\title{Assemble the gradient of h}
\usage{
buildDh(G, Df, DG, Hf, HG)
}
\arguments{
\item{G}{a vector valued constraint function which takes input \code{X} and
should yield a vector of 0's when all constraints are satisfied. See
\code{\link{aggregateConstraints}}.}

\item{Df}{a vector valued function representing the gradient of the objective
function, \code{f}. \code{Df} should take \code{(X,lambda)} as primary
arguments, though it must take \code{(X, lambda, data)} as arguments if
\code{\link{SGD}} is to be used.}

\item{DG}{a matrix valued function representing the matrix of gradients of
constraint functions. See \code{\link{aggregateGradients}}.}

\item{Hf}{the Hessian matrix of the objective function, \code{f}. \code{Hf}
should take \code{(X,lambda)} as primary arguments, if
\code{\link{gradientDescent}} is being used to optimize \code{f}. If
\code{\link{SGD}} is being called, it must take \code{(X, lambda, data)} as
arguments.}

\item{HG}{the (aggregate) Hessian of the constrain function \code{G}. This
object must have the same form as the output to \code{\link{aggregateHessians}}.}
}
\value{
a vector-valued function \code{Dh(X, lambda, data)} which is the
gradient of \code{h} as created in \code{\link{build_h}}.
}
\description{
Assemble the gradient of h from the second and first derivatives
of the objective and constraint functions.
}
\details{


The definition for \code{h} and \code{Dh} can be found in
\code{inst/final_project/final_paper/final_paper.pdf}.
}
\examples{
Df <- function(X){
x <- X[1]; y <- X[2]; z <- X[3]
c(1 + 2*x + y + z, 1 + x + 2*y + z, 1 + x + y + 2*z)
}

Hf <- function(X){
  matrix(c(2,1,1,1,2,1,1,1,2), nrow=3, byrow=TRUE)
}

g1 <- function(X) {
  as.numeric(c(1,1,1) \%*\% X^4 - 1)
}

g2 <- function(X) {
  as.numeric(c(1,1,1) \%*\% X^2 - 1)
}

Dg1 <- function(X){
  4 * X^3
}

Dg2 <- function(X){
  2 * X
}

Hg1 <- function(X){
  matrix(12 * c(X[1], 0, 0, 0, X[2], 0, 0, 0, X[3])^2, nrow=3, byrow=TRUE)
}

Hg2 <- function(X){
  matrix(c(2, 0, 0, 0, 2, 0, 0, 0, 2), nrow=3, byrow=TRUE)
}

Dh <- buildDh(G=aggregateConstraints(g1, g2),
             Df=Df,
             DG=aggregateGradients(Dg1, Dg2),
             Hf=Hf,
             HG=aggregateHessians(Hg1, Hg2))

Dh(c(1,1,1), c(1,1))
}
\seealso{
Other blowtorch wrappers: \code{\link{build_h}}
}

