% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmm.R
\name{bmm}
\alias{bmm}
\alias{fit_model}
\title{Fit Bayesian Measurement Models}
\usage{
bmm(
  formula,
  data,
  model,
  prior = NULL,
  sort_data = getOption("bmm.sort_data", "check"),
  silent = getOption("bmm.silent", 1),
  backend = getOption("brms.backend", NULL),
  file = NULL,
  file_compress = TRUE,
  file_refit = getOption("bmm.file_refit", FALSE),
  ...
)

fit_model(
  formula,
  data,
  model,
  prior = NULL,
  sort_data = getOption("bmm.sort_data", "check"),
  silent = getOption("bmm.silent", 1),
  backend = getOption("brms.backend", NULL),
  ...
)
}
\arguments{
\item{formula}{An object of class \code{bmmformula}. A symbolic description of the
model to be fitted.}

\item{data}{An object of class data.frame, containing data of all variables
used in the model. The names of the variables must match the variable names
passed to the \code{bmmodel} object for required argurments.}

\item{model}{A description of the model to be fitted. This is a call to a
\code{bmmodel} such as \code{mixture3p()} function. Every model function has a
number of required arguments which need to be specified within the function
call. Call \code{\link[=supported_models]{supported_models()}} to see the list of supported models and
their required arguments}

\item{prior}{One or more \code{brmsprior} objects created by \code{\link[brms:set_prior]{brms::set_prior()}}
or related functions and combined using the c method or the + operator. See
also \code{\link[=default_prior]{default_prior()}} for more help. Not necessary for the default model
fitting, but you can provide prior constraints to model parameters}

\item{sort_data}{Logical. If TRUE, the data will be sorted by the predictor
variables for faster sampling. If FALSE, the data will not be sorted, but
sampling will be slower. If "check" (the default), \code{\link[=bmm]{bmm()}} will check if
the data is sorted, and ask you via a console prompt if it should be
sorted. You can set the default value for this option using global
\verb{options(bmm.sort_data = TRUE/FALSE/"check)})\verb{or via}bmm_options(sort_data)`}

\item{silent}{Verbosity level between 0 and 2. If 1 (the default), most of the
informational messages of compiler and sampler are suppressed. If 2, even
more messages are suppressed. The actual sampling progress is still
printed. Set refresh = 0 to turn this off as well. If using backend =
"rstan" you can also set open_progress = FALSE to prevent opening
additional progress bars.}

\item{backend}{Character. The backend to use for fitting the model. Can be
"rstan" or "cmdstanr". If NULL (the default), "cmdstanr" will be used if
the cmdstanr package is installed, otherwise "rstan" will be used. You can
set the default backend using global \code{options(brms.backend = "rstan"/"cmdstanr")}}

\item{file}{Either \code{NULL} or a character string. If a string, the fitted
model object is saved via \link{saveRDS} in a file named after the string. The
\verb{.rds extension is added automatically. If the file already exists, }bmm\verb{will load and return the saved model object. Unless you specify the}file_refit\verb{argument as well, the existing files won't be overwritten, you have to manually remove the file in order to refit and save the model under an existing file name. The file name is stored in the}bmmfit` object for
later usage. If the directory of the file does not exist, it will be created.}

\item{file_compress}{Logical or a character string, specifying one of the
compression algorithms supported by \link{saveRDS} when saving
the fitted model object.}

\item{file_refit}{Logical. Modifies when the fit stored via the \code{file} argument is
re-used. Can be set globally for the current \R session via the
\code{"bmm.file_refit"} option (see \link{options}). If \code{TRUE} (the default), the
model is re-used if the file exists. If \code{FALSE}, the model is re-fitted. Note
that unlike \code{brms}, there is no "on_change" option}

\item{...}{Further arguments passed to \code{\link[brms:brm]{brms::brm()}} or Stan. See the
description of \code{\link[brms:brm]{brms::brm()}} for more details}
}
\value{
An object of class brmsfit which contains the posterior draws along
with many other useful information about the model. Use methods(class =
"brmsfit") for an overview on available methods.
}
\description{
Fit a Bayesian measurement model using \strong{brms} as a
backend interface to Stan.
}
\section{Supported Models}{
The following models are supported:
\itemize{
\item imm(resp_error, nt_features, nt_distances, set_size, regex, version)
\item mixture2p(resp_error)
\item mixture3p(resp_error, nt_features, set_size, regex)
\item sdm(resp_error, version)
}

Type  ?modelname  to get information about a specific model, e.g.  ?imm
}

\section{bmmformula syntax}{
see \href{https://venpopov.github.io/bmm/articles/bmm_bmmformula.html}{this online article} for a detailed description of the syntax and how
it differs from the syntax for \strong{brmsformula}
}

\section{Default priors, Stan code and Stan data}{
For more information about the default priors in \strong{bmm} and about who to extract the Stan code and data generated by bmm and #'   brms, see \href{https://venpopov.github.io/bmm/articles/bmm_extract_info.html}{the online article}.
}

\section{Miscellaneous}{
Type \code{help(package=bmm)} for a full list of available help topics.

\strong{fit_model()} is a deprecated alias for \strong{bmm()}.
}

\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# generate artificial data from the Signal Discrimination Model
dat <- data.frame(y = rsdm(2000))

# define formula
ff <- bmmformula(c ~ 1, kappa ~ 1)

# fit the model
fit <- bmm(formula = ff,
           data = dat,
           model = sdm(resp_error = "y"),
           cores = 4,
           backend = 'cmdstanr')
\dontshow{\}) # examplesIf}
}
\references{
Frischkorn, G. T., & Popov, V. (2023). A tutorial for estimating
mixture models for visual working memory tasks in brms: Introducing the
Bayesian Measurement Modeling  (bmm) package for R.
https://doi.org/10.31234/osf.io/umt57
}
\seealso{
\code{\link[=supported_models]{supported_models()}}, \code{\link[brms:brm]{brms::brm()}}, \link[=default_prior.bmmformula]{default_prior()}, \code{\link[=bmmformula]{bmmformula()}}, \link[=stancode.bmmformula]{stancode()}, \link[=standata.bmmformula]{standata()}
}
\keyword{deprecated}
