% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_ao.R
\name{my_ao}
\alias{my_ao}
\title{Create additive outlier variables}
\usage{
my_ao(dates, out.list)
}
\arguments{
\item{dates}{Vector of dates in a date format}

\item{out.list}{Vector of outlier dates in a date format}
}
\value{
AO matrix with outlier variables
}
\description{
Creates a matrix with additive outlier variables. Uses the original data dates and the user specified outlier dates.
}
\examples{

# create a sequence of dates
dates=seq.Date(from=as.Date("2023-01-02"),by="weeks",length.out = 100)
# create a vector of outlier dates
my_ao_dates=as.Date(c("2023-01-02","2023-01-03"))
# create a matrix of AO variables
my_ao(dates = dates,out.list = my_ao_dates)
# as you can see there is only one column corresponding to 2023-01-02,
# the second date is ignored because it is not present in the dates vector

}
