% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boomer-package.R
\docType{package}
\name{boomer-package}
\alias{boomer-package}
\alias{_PACKAGE}
\alias{boomer}
\title{boomer: Debugging Tools to Inspect the Intermediate Steps of a Call}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Provides debugging tools that let you inspect the intermediate results of a call. The output looks as if we explode a call into its parts hence the package name.
}
\details{
\itemize{
\item \code{\link[=boom]{boom()}} displays the intermediate results of a call or a code chunk.
\item \code{\link[=rig]{rig()}} creates a copy of a function which will display the intermediate
results of all the calls of it body.
\item \code{\link[=rig_in_namespace]{rig_in_namespace()}} rigs a namespaced function in place, so its always
verbose even when called by other existing functions. It is especially handy
for package development.
\item \code{\link[=rigger]{rigger()}} provides a convenient way to rig an
anonymous function by using the \code{rigger(...) + function(...) {...}} syntax.
\item The addin "Explode a call with 'boom()'" provides a way to \code{boom()} a call
with a keyboard shortcut.
}
}
\section{Package options}{


Several options impact the display of exploded calls :
\itemize{
\item \code{boomer.print}: If the \code{print} argument is not provided, this option will
replace it at run time. Defaults to the \code{base::print} function.
\item \code{boomer.clock}: If the \code{clock} argument is not provided, this option will
replace it at run time. Defaults to \code{FALSE}.
\item \code{boomer.print_args}: Whether to print the arguments of rigged functions
and their values when they are evaluated. Defaults to \code{TRUE}.
\item \code{boomer.visible_only}: Whether to hide the output of functions which return
invisibly. Defaults to \code{FALSE}.
\item \code{boomer.ignore}: Vector of functions for which we don't want the result
printed (usually because it's redundant). Defaults to
\code{c("~", "{", "(", "<-", "<<-", "=")}
\item \code{boomer.safe_print}: Whether to replace emoticons by characters compatible
with all systems. This is useful for reprexes (see {reprex} package) and
for knitted report in case the output of those doesn't look good on your system.
\item \code{boomer.abbreviate}: Whether to show only the function's name rather than the
call when it's entered.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/moodymudskipper/boomer}
  \item Report bugs at \url{https://github.com/moodymudskipper/boomer/issues}
}

}
\author{
\strong{Maintainer}: Antoine Fabri \email{antoine.fabri@gmail.com}

}
