% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_distribution.R
\name{logistic_distribution}
\alias{logistic_distribution}
\alias{logistic_pdf}
\alias{logistic_lpdf}
\alias{logistic_cdf}
\alias{logistic_lcdf}
\alias{logistic_quantile}
\title{Logistic Distribution Functions}
\usage{
logistic_pdf(x, location = 0, scale = 1)

logistic_lpdf(x, location = 0, scale = 1)

logistic_cdf(x, location = 0, scale = 1)

logistic_lcdf(x, location = 0, scale = 1)

logistic_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Logistic distribution.
}
\examples{
# Logistic distribution with location = 0, scale = 1
logistic_pdf(0)
logistic_lpdf(0)
logistic_cdf(0)
logistic_lcdf(0)
logistic_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/1_87_0/libs/math/doc/html/math_toolkit/dist_ref/dists/logistic_dist.html}{Boost Documentation} for more details on the mathematical background.
}
