% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pareto_distribution.R
\name{pareto_distribution}
\alias{pareto_distribution}
\alias{pareto_pdf}
\alias{pareto_lpdf}
\alias{pareto_cdf}
\alias{pareto_lcdf}
\alias{pareto_quantile}
\title{Pareto Distribution Functions}
\usage{
pareto_pdf(x, shape = 1, scale = 1)

pareto_lpdf(x, shape = 1, scale = 1)

pareto_cdf(x, shape = 1, scale = 1)

pareto_lcdf(x, shape = 1, scale = 1)

pareto_quantile(p, shape = 1, scale = 1)
}
\arguments{
\item{x}{quantile}

\item{shape}{shape parameter (default is 1)}

\item{scale}{scale parameter (default is 1)}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Pareto distribution.
}
\examples{
# Pareto distribution with shape = 1, scale = 1
pareto_pdf(1)
pareto_lpdf(1)
pareto_cdf(1)
pareto_lcdf(1)
pareto_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/pareto.html}{Boost Documentation} for more details on the mathematical background.
}
