% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_functionals.R
\name{vector_functionals}
\alias{vector_functionals}
\alias{l0_pseudo_norm}
\alias{hamming_distance}
\alias{l1_norm}
\alias{l1_distance}
\alias{l2_norm}
\alias{l2_distance}
\alias{sup_norm}
\alias{sup_distance}
\alias{lp_norm}
\alias{lp_distance}
\alias{total_variation}
\title{Vector Functionals}
\usage{
l0_pseudo_norm(x)

hamming_distance(x, y)

l1_norm(x)

l1_distance(x, y)

l2_norm(x)

l2_distance(x, y)

sup_norm(x)

sup_distance(x, y)

lp_norm(x, p)

lp_distance(x, y, p)

total_variation(x)
}
\arguments{
\item{x}{A numeric vector.}

\item{y}{A numeric vector of the same length as \code{x} (for distance functions).}

\item{p}{A positive integer indicating the order of the norm or distance (for Lp functions).}
}
\value{
A single numeric value with the computed norm or distance.
}
\description{
Functions to compute various vector norms and distances.
}
\examples{
# L0 Pseudo Norm
l0_pseudo_norm(c(1, 0, 2, 0, 3))
# Hamming Distance
hamming_distance(c(1, 0, 1), c(0, 1, 1))
# L1 Norm
l1_norm(c(1, -2, 3))
# L1 Distance
l1_distance(c(1, -2, 3), c(4, -5, 6))
# L2 Norm
l2_norm(c(3, 4))
# L2 Distance
l2_distance(c(3, 4), c(0, 0))
# Supremum Norm
sup_norm(c(1, -2, 3))
# Supremum Distance
sup_distance(c(1, -2, 3), c(4, -5, 6))
# Lp Norm
lp_norm(c(1, -2, 3), 3)
# Lp Distance
lp_distance(c(1, -2, 3), c(4, -5, 6), 3)
# Total Variation
total_variation(c(1, 2, 1, 3))
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/vector_functionals.html}{Boost Documentation} for more details on the mathematical background.
}
