% Generated by roxygen2 (4.0.0): do not edit by hand
\name{vanillaBagger}
\alias{vanillaBagger}
\title{Standard (vanilla) bagging procedure.}
\usage{
vanillaBagger(prediction, response, ...)
}
\arguments{
\item{prediction}{a vector of predictions.}

\item{response}{a vector whose \eqn{i^{th}}{ith} component is the true
response for the \eqn{i^{th}}{ith} component of \code{prediction}.}

\item{...}{implemented to allow reweighter to accept its output as its input.}
}
\value{
a list with component '\code{weights}':
a normalized vector of 1's with length equal to that of \code{response}.
}
\description{
Build an estimator from a simple resampling of data.
}
\note{
a "bagger" is just a reweighter who returns uniform weights regardless of
the input.
}
\seealso{
Other reweighters: \code{\link{adaboostReweighter}};
  \code{\link{arcfsReweighter}};
  \code{\link{arcx4Reweighter}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}}
}

