% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag_mts.R
\name{lag_mts}
\alias{lag_mts}
\title{Create matrix of lagged variables}
\usage{
lag_mts(X, k, last.only = FALSE)
}
\arguments{
\item{X}{numeric matrix whose columns are subject to lagging}

\item{k}{vector of lag orders}

\item{last.only}{If TRUE only the k-th order lag will be computed, otherwise all lags from 1 to k}
}
\value{
a matrix whose columns are the original variables and the k-th order lagged variables. Column name suffix ".lx".
}
\description{
Create matrix of lagged variables
}
\examples{

data(ger_macro)

lag_mts(X = ger_macro, k = 3, last.only = FALSE)

}
